/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jclass.datasource.DataModel;
import jclass.datasource.DataModelEvent;
import jclass.datasource.DataModelException;
import jclass.datasource.DataModelListener;
import jclass.datasource.DataTableModel;
import jclass.datasource.MetaDataModel;
import jclass.datasource.treemodel.Tree;
import jclass.datasource.treemodel.TreeModel;
import jclass.datasource.treemodel.TreeNode;
import jclass.datasource.treemodel.TreeNodeModel;
import jclass.util.JCListenerList;

public class TreeData
implements DataModel,
Serializable {
    static final long serialVersionUID = 1382527574414366871L;
    protected Tree meta_tree = new Tree();
    protected transient Tree data_tree = new Tree();
    JCListenerList listeners;
    transient DataTableModel currentDataTable;
    long currentBookmark = -1L;
    boolean eventsEnabled = true;
    private static int nameCounter;
    private String modelName = "TreeData" + nameCounter++;

    public TreeModel getMetaDataTree() {
        return this.meta_tree;
    }

    public TreeModel getDataTableTree() {
        return this.data_tree;
    }

    public void addDataModelListener(DataModelListener dataModelListener) {
        this.listeners = JCListenerList.add(this.listeners, dataModelListener);
    }

    public void removeDataModelListener(DataModelListener dataModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, dataModelListener);
    }

    public Object getListeners() {
        return this.listeners;
    }

    public boolean moveToRow(DataModelListener dataModelListener, DataTableModel dataTableModel, long l) throws DataModelException {
        return this.moveToRow(dataModelListener, dataTableModel, l, true);
    }

    public boolean moveToRow(DataModelListener dataModelListener, DataTableModel dataTableModel, long l, boolean bl) throws DataModelException {
        if (this.currentDataTable != null && l == this.currentBookmark) {
            return true;
        }
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, l, "", 11))) {
            return false;
        }
        if (this.currentDataTable == null) {
            this.currentDataTable = (DataTableModel)((Object)this.getDataTableTree().getRoot());
            this.currentBookmark = this.currentDataTable.first() ? this.currentDataTable.getCurrentBookmark() : l;
        }
        int n = dataTableModel.getRowIndex(l);
        if (this.currentDataTable.getRootAncestorBookmark(this.currentBookmark) == dataTableModel.getRootAncestorBookmark(l) ? this.currentDataTable.getMetaData().getCommitPolicy() == 1 && this.currentDataTable.getRowStatus(this.currentBookmark) != 4 && this.currentDataTable.getRowStatus(this.currentBookmark) != 5 && !this.currentDataTable.commitRow(dataModelListener, this.currentBookmark) : ((DataTableModel)((Object)this.getDataTableTree().getRoot())).isSubTreeModified(this.currentDataTable.getRootAncestorBookmark(this.currentBookmark)) && !this.conditionallyCommitSubTreeRootedAt(dataModelListener, this.currentDataTable.getRootAncestorBookmark(this.currentBookmark))) {
            return false;
        }
        if (this.resetHappened(dataTableModel, l)) {
            l = this.currentDataTable.getRowIdentifier(n);
        } else {
            this.currentDataTable = dataTableModel;
        }
        this.currentBookmark = l;
        if (bl) {
            try {
                this.currentDataTable.moveToRow(l);
            }
            catch (Exception exception) {
                throw new DataModelException(106, exception);
            }
        }
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, this.currentDataTable, l, "", 106));
        return true;
    }

    private boolean resetHappened(DataTableModel dataTableModel, long l) {
        DataTableModel dataTableModel2 = (DataTableModel)((Object)this.getDataTableTree().getRoot());
        if (((TreeNode)((Object)dataTableModel)).getParent() == null && dataTableModel != dataTableModel2) {
            return true;
        }
        return dataTableModel2.getRowIndex(dataTableModel.getRootAncestorBookmark(l)) == -1;
    }

    private boolean conditionallyCommitSubTreeRootedAt(DataModelListener dataModelListener, long l) throws DataModelException {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.data_tree.getRoot());
        MetaDataModel metaDataModel = (MetaDataModel)this.getMetaDataTree().getRoot();
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, l, "", 9))) {
            return false;
        }
        try {
            if (dataTableModel.getMetaData().getCommitPolicy() == 1 && dataTableModel.getRowStatus(l) != 4 && dataTableModel.getRowStatus(l) != 5) {
                dataTableModel.commitRow(dataModelListener, l);
            }
            Enumeration enumeration = ((TreeNode)((Object)dataTableModel)).getChildren().elements();
            while (enumeration.hasMoreElements()) {
                DataTableModel dataTableModel2 = (DataTableModel)enumeration.nextElement();
                if (dataTableModel2.getParentBookmark() != l) continue;
                dataTableModel2.conditionallyCommitYourselfAndChildren(dataModelListener);
            }
            metaDataModel.commitTransaction();
            dataTableModel.processEventQueue(dataModelListener);
        }
        catch (Exception exception) {
            try {
                metaDataModel.rollbackTransaction();
            }
            catch (Exception exception2) {}
            dataTableModel.clearEventQueue();
            this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 105));
            throw exception instanceof DataModelException ? (DataModelException)exception : new DataModelException(6, exception);
        }
        return true;
    }

    public void updateAll(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getDataTableTree().getRoot());
        MetaDataModel metaDataModel = (MetaDataModel)this.getMetaDataTree().getRoot();
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 6))) {
            return;
        }
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 104));
        try {
            dataTableModel.commitAll(dataModelListener);
            metaDataModel.commitTransaction();
            dataTableModel.processEventQueue(dataModelListener);
        }
        catch (Exception exception) {
            try {
                metaDataModel.rollbackTransaction();
            }
            catch (Exception exception2) {}
            dataTableModel.clearEventQueue();
            this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 105));
            throw exception instanceof DataModelException ? (DataModelException)exception : new DataModelException(6, exception);
        }
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 105));
    }

    public void cancelAll(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getDataTableTree().getRoot());
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 7))) {
            return;
        }
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 104));
        if (this.currentDataTable != null && this.currentBookmark != -1L) {
            this.currentDataTable.cancelRowChanges(dataModelListener, this.currentBookmark);
        }
        dataTableModel.cancelAllRowChanges(dataModelListener);
        this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 105));
    }

    public void requeryAll(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.data_tree.getRoot());
        if (!this.fireDataModelEvent(new DataModelEvent(this, dataModelListener, dataTableModel, -1L, "", 2))) {
            return;
        }
        ((TreeNodeModel)((Object)dataTableModel)).removeChildren();
        MetaDataModel metaDataModel = (MetaDataModel)this.getMetaDataTree().getRoot();
        try {
            this.clearCurrentPath(metaDataModel);
            metaDataModel.setCurrentDataTable(null);
            metaDataModel.setCurrentBookmark(-1L);
            DataTableModel dataTableModel2 = dataTableModel.requeryLevel();
            this.data_tree.setRoot(dataTableModel2);
            metaDataModel.setCurrentDataTable(dataTableModel2);
            dataTableModel2.first();
            long l = dataTableModel2.getCurrentBookmark();
            metaDataModel.setCurrentBookmark(l);
            this.currentDataTable = dataTableModel2;
            this.currentBookmark = l;
            DataModelEvent dataModelEvent = new DataModelEvent(this, dataModelListener, dataTableModel2, l, "", 103);
            this.fireDataModelEvent(dataModelEvent);
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(103, exception);
        }
    }

    public void clearCurrentPath(MetaDataModel metaDataModel) {
        if (metaDataModel == null) {
            return;
        }
        Enumeration enumeration = metaDataModel.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            MetaDataModel metaDataModel2 = (MetaDataModel)enumeration.nextElement();
            this.clearCurrentPath2(metaDataModel2);
        }
    }

    void clearCurrentPath2(MetaDataModel metaDataModel) {
        if (metaDataModel == null) {
            return;
        }
        Enumeration enumeration = metaDataModel.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            MetaDataModel metaDataModel2 = (MetaDataModel)enumeration.nextElement();
            this.clearCurrentPath2(metaDataModel2);
        }
        metaDataModel.setCurrentDataTable(null);
        metaDataModel.setCurrentBookmark(-1L);
    }

    public boolean fireDataModelEvent(DataModelEvent dataModelEvent) {
        boolean bl = true;
        if (!this.eventsEnabled) {
            return bl;
        }
        Enumeration enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            try {
                DataModelListener dataModelListener = (DataModelListener)enumeration.nextElement();
                if (dataModelEvent.getCommand() == 107) {
                    dataModelListener.dataModelCreated(dataModelEvent);
                } else {
                    dataModelListener.dataModelChanged(dataModelEvent);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            if (dataModelEvent == null || !dataModelEvent.getCancelled()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void enableDataModelEvents(boolean bl) {
        this.eventsEnabled = bl;
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public DataTableModel getCurrentGlobalTable() {
        return this.currentDataTable;
    }

    public long getCurrentGlobalBookmark() {
        return this.currentBookmark;
    }

    public DataTableModel getCurrentDataTable(DataModelListener dataModelListener, MetaDataModel metaDataModel) throws DataModelException {
        this.setOrCreatePathFromRootToMe(dataModelListener, metaDataModel);
        return metaDataModel.getCurrentDataTable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setOrCreatePathFromRootToMe(DataModelListener dataModelListener, MetaDataModel metaDataModel) throws DataModelException {
        MetaDataModel metaDataModel2 = (MetaDataModel)metaDataModel.getParent();
        if (metaDataModel2 == null) {
            metaDataModel.setCurrentDataTable((DataTableModel)((Object)this.getDataTableTree().getRoot()));
            return;
        }
        DataTableModel dataTableModel = metaDataModel.getCurrentDataTable();
        metaDataModel.getCurrentBookmark();
        if (dataTableModel != null) {
            if (this.ancestorPathPointsToMe(dataTableModel)) return;
            this.setOrCreatePathFromRootToMe(dataModelListener, (MetaDataModel)metaDataModel.getParent());
        } else {
            this.setOrCreatePathFromRootToMe(dataModelListener, (MetaDataModel)metaDataModel.getParent());
        }
        DataTableModel dataTableModel2 = metaDataModel2.getCurrentDataTable();
        if (dataTableModel2 == null) {
            this.setOrCreatePathFromRootToMe(dataModelListener, metaDataModel2);
            dataTableModel2 = metaDataModel2.getCurrentDataTable();
        }
        DataTableModel dataTableModel3 = null;
        long l = -1L;
        if (dataTableModel2 != null && (dataTableModel3 = dataTableModel2.createTable(dataModelListener, metaDataModel2.getCurrentBookmark(), (TreeNode)((Object)metaDataModel))) != null) {
            dataTableModel3.first();
            if (dataTableModel3.getRowCount() > 0) {
                l = dataTableModel3.getCurrentBookmark();
            }
        }
        metaDataModel.setCurrentDataTable(dataTableModel3);
        metaDataModel.setCurrentBookmark(l);
    }

    private boolean ancestorPathPointsToMe(DataTableModel dataTableModel) {
        Vector vector = new Vector();
        dataTableModel.getAncestors(vector);
        int n = 0;
        while (n < vector.size()) {
            MetaDataModel metaDataModel = ((DataTableModel)((Object)((TreeNode)((Object)dataTableModel)).getParent())).getMetaData();
            if (!vector.contains(new Long(metaDataModel.getCurrentBookmark()))) {
                return false;
            }
            dataTableModel = (DataTableModel)((Object)((TreeNodeModel)((Object)dataTableModel)).getParent());
            ++n;
        }
        return true;
    }

    public Object getCurrentDataItem(DataModelListener dataModelListener, MetaDataModel metaDataModel, String string) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTable(dataModelListener, metaDataModel);
        long l = metaDataModel.getCurrentBookmark();
        if (dataTableModel != null && l != -1L && dataTableModel.getRowStatus(l) != 5 && dataTableModel.getRowStatus(l) != 3) {
            return dataTableModel.getResultData(l, string);
        }
        return null;
    }

    public MetaDataModel getMetaData(String string) {
        MetaDataModel metaDataModel = (MetaDataModel)this.getMetaDataTree().getRoot();
        return this.getMetaDataByName(metaDataModel, string);
    }

    private MetaDataModel getMetaDataByName(MetaDataModel metaDataModel, String string) {
        if (metaDataModel == null || metaDataModel.getDescription().equals(string)) {
            return metaDataModel;
        }
        Enumeration enumeration = metaDataModel.getChildren().elements();
        MetaDataModel metaDataModel2 = null;
        while (enumeration.hasMoreElements()) {
            MetaDataModel metaDataModel3 = (MetaDataModel)enumeration.nextElement();
            metaDataModel2 = this.getMetaDataByName(metaDataModel3, string);
            if (metaDataModel2 != null) break;
        }
        return metaDataModel2;
    }

    public boolean isModified() {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getDataTableTree().getRoot());
        if (dataTableModel.isModified()) {
            return true;
        }
        return dataTableModel.isTableOrChildrenModified();
    }
}

